//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <AmazonIVSPlayer/IVSBase.h>
#import <CoreMedia/CoreMedia.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class IVSQuality;
@class IVSSourceGroup;

/// Represents a preloaded source fetched by the `-[IVSPlayer preload:completionHandler:]` method.
/// @see `-[IVSPlayer preload:completionHandler:]`
/// @see `-[IVSPlayer loadSource:]`
IVS_EXPORT
NS_SWIFT_SENDABLE
@interface IVSSource : NSObject

IVS_INIT_UNAVAILABLE

/// The path this Source was preloaded from.
@property (nonatomic, readonly) NSURL *path;

/// Quality objects from the preloaded source.
/// This contains the qualities that can be assigned to `quality` on the IVSPlayer instance.
/// Note that this set will contain only qualities capable of being played on the current device
/// and not all those present in the source stream.
@property (nonatomic, readonly) NSArray<IVSQuality *> *qualities;

/// Source group objects from the loaded source or empty if none are currently available.
/// This contains the source groups whose names can be assigned to  `sourceGroup`
/// on the IVSPlayer instance.  SourceGroup objects also contain qualities for the group.
@property (nonatomic, readonly) NSArray<IVSSourceGroup *> *groups;

/// Returns the Time To Live (TTL) value for this source.
/// This value indicates how long the source remains valid before requiring a refresh.
@property (nonatomic, readonly) CMTime timeToLive;

/// Retrieve a session data value for the provided key. If the value does not exist, this will
/// return nil.
- (NSString * _Nullable)sessionData:(NSString *)key;

#pragma mark - Comparison and equality

/// Returns a boolean value that indicates whether a given Source is equal to another.
/// @param other Another Source instance
- (BOOL)isEqualToSource:(IVSSource *)other;

@end

NS_ASSUME_NONNULL_END
