//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSPlayer/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

/// Represents ad time progress during playback.
/// @note This API is in beta and may change.
IVS_EXPORT
NS_SWIFT_SENDABLE
@interface IVSAdTimeUpdate : NSObject

IVS_INIT_UNAVAILABLE

/// Unique identifier for the ad break.
@property (nonatomic, readonly, copy) NSString *adBreakId;

/// Unique identifier for the current ad creative.
@property (nonatomic, readonly, copy) NSString *assetId;

/// Elapsed time within the ad break in seconds.
@property (nonatomic, readonly) NSTimeInterval breakElapsed;

/// Total duration of the ad break in seconds.
@property (nonatomic, readonly) NSTimeInterval breakDuration;

/// Elapsed time within the current creative in seconds.
@property (nonatomic, readonly) NSTimeInterval creativeElapsed;

/// Total duration of the current creative in seconds.
@property (nonatomic, readonly) NSTimeInterval creativeDuration;

/// 1-based index of the current creative within the ad break.
@property (nonatomic, readonly) NSUInteger podIndex;

/// Total number of creatives in the ad break.
@property (nonatomic, readonly) NSUInteger podLength;

@end

NS_ASSUME_NONNULL_END
