//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSPlayer/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

/// Represents an ad creative during playback.
/// @note This API is in beta and may change.
IVS_EXPORT
NS_SWIFT_SENDABLE
@interface IVSAdCreative : NSObject

IVS_INIT_UNAVAILABLE

/// Unique identifier for the ad break this creative belongs to.
@property (nonatomic, readonly, copy) NSString *adBreakId;

/// Unique identifier for this ad creative.
@property (nonatomic, readonly, copy) NSString *assetId;

/// 1-based index of this creative within the ad break.
@property (nonatomic, readonly) NSUInteger podIndex;

/// Duration of the ad creative in seconds.
@property (nonatomic, readonly) NSTimeInterval duration;

@end

NS_ASSUME_NONNULL_END
