//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSPlayer/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

/// Type of ad break.
/// @note This API is in beta and may change.
typedef NS_ENUM(NSInteger, IVSAdBreakRollType) {
    /// Preroll ad break, plays before content.
    IVSAdBreakRollTypePreroll,
    /// Midroll ad break, plays during content.
    IVSAdBreakRollTypeMidroll,
    /// Postroll ad break, plays after content.
    IVSAdBreakRollTypePostroll,
    /// Unknown roll type.
    IVSAdBreakRollTypeUnknown
} NS_SWIFT_NAME(IVSAdBreak.RollType);

/// Represents an ad break during playback.
/// @note This API is in beta and may change.
IVS_EXPORT
NS_SWIFT_SENDABLE
@interface IVSAdBreak : NSObject

IVS_INIT_UNAVAILABLE

/// Unique identifier for this ad break.
@property (nonatomic, readonly, copy) NSString *adBreakId;

/// The roll type of the ad break.
@property (nonatomic, readonly) IVSAdBreakRollType rollType;

/// Duration of the ad break in seconds.
@property (nonatomic, readonly) NSTimeInterval duration;

/// Number of creatives (ads) in this ad break.
@property (nonatomic, readonly) NSUInteger podLength;

@end

NS_ASSUME_NONNULL_END
