//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <AmazonIVSPlayer/IVSPlayer.h>

NS_ASSUME_NONNULL_BEGIN

@class IVSSource;

/// "Beta" APIs which are subject to breaking change / removal in upcoming IVSPlayer releases.
/// Use at your own risk.
@interface IVSPlayer (IVSInternal)

/// Asynchronously preloads a stream at the specified URL. Calls to this method can be made in
/// sequence without waiting for the previous calls to complete (as indicated by the
/// `completionHandler` parameter).
///
/// @param path Location of the streaming manifest. Does not work with clips or files, unlike the load method.
/// @param completionHandler The completion handler to call when the preload request is complete.
///                          This completion handler takes the following parameters:
///     - source: The source object to be used in a future call to `-[IVSPlayer loadSource:]`, or `nil` if the preload failed.
///     - error: An error object that indicates why the preload failed, or `nil` if the preload was successful.
/// @see `IVSSource`
///
- (void)preload:(NSURL *)path completionHandler:(void (^)(IVSSource * _Nullable source, NSError * _Nullable error))completionHandler;

/// Loads the stream which has been preloaded into the specified `IVSSource` object.
/// `loadSource` with a valid `IVSSource` object is at least one network round-trip
/// faster than `load`, so use the `preload` ==> `loadSource` flow when the next
/// source for playback is known ahead of time.
/// @param source The pre-loaded source object returned by a previous preload call.
/// @see `IVSSource`
- (void)loadSource:(IVSSource *)source NS_SWIFT_NAME(load(_:));

@end

NS_ASSUME_NONNULL_END

