//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
#import <Foundation/Foundation.h>
#import <AmazonIVSPlayer/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

/// Describes a media rendition that is unavailable for playback
/// The quality was either removed by the server or by the client.
/// Unavailable qualities cannot be used as a normal Quality object,
/// and do not map to a source rendition.
/// @see `IVSPlayer.unavailableQuality`
IVS_EXPORT
@interface IVSUnavailableQuality : NSObject

IVS_INIT_UNAVAILABLE

/**
 * The name of the quality object.
 */
@property (nonatomic, readonly, copy) NSString *name;

/**
 * Codec string representing the media codec information, e.g. "avc1.64002A,mp4a.40.2"
 */
@property (nonatomic, readonly, copy) NSString *codecs;

/**
 * The width of the unavailable quality in pixels
 */
@property (nonatomic, readonly) NSInteger width;

/**
 * The height of the unavailable quality in pixels
 */
@property (nonatomic, readonly) NSInteger height;

/**
 * The HLS group ID of the quality object.
 */
@property (nonatomic, readonly, copy) NSString *group;

/**
 * The bitrate of the media expressed as bits per second
 */
@property (nonatomic, readonly) NSInteger bitrate;

/**
 * The framerate of the quality expressed as frames per second
 */
@property (nonatomic, readonly) float framerate;

/**
 * If populated, describes the technical reasons which resulted in the server or client removing this quality
 * from the available quality list.
 */
@property (nonatomic, readonly, copy) NSArray<NSString *> *filterReasons;

/**
 * If populated, describes the authorization failures which resulted in the server removing this quality from
 * the available quality list.
 */
@property (nonatomic, readonly, copy) NSArray<NSString *> *authReasons;

@end

NS_ASSUME_NONNULL_END
